******************************************************************************
*                        680xx Grundprogramm srdio                           *
*                        (C) 1990 Ralph Dombrowski                           *
*                            2008 Jens Mewes                                 *
*                                Rev 7.10                                    *
*                               01.01.2008                                   *
*                           SRAMDISK-Routinen                                *
******************************************************************************


srdinit:                        * SDRAMDISK initialisieren
 clr.b flo2srd(a5)
 clr srdcap(a5)
 movem.l d0/a0/a1, -(a7)
 lea srddata.w, a1              * Lade Datenregisteradresse
 move #0, d0                    * Sektor #0
 bsr.s sridtst                  * Teste, ob Sektor vorhanden
 bcc.s srdinit1                 * OK, weiter testen
 move #0, d0                    * Ergebnis 'nicht vorhanden'
 bra.s srdinitx
srdinit1:
 move #512, d0                  * Sektor #512
 bsr.s sridtst                  * Teste, ob Sektor vorhanden
 bcc.s srdinit2                 * OK, weiter testen
 move #511, d0                  * Ergebnis 'Kapazitaet 512 kB'
 bra.s srdinite
srdinit2:
 move #1024, d0                 * Sektor #1024
 bsr.s sridtst                  * Teste, ob Sektor vorhanden
 bcc.s srdinit3                 * OK, weiter testen
 move #1023, d0                 * Ergebnis 'Kapazitaet 1024 kB'
 bra.s srdinite
srdinit3:
 move #1536, d0                 * Sektor #1536
 bsr.s sridtst                  * Teste, ob Sektor vorhanden
 bcc.s srdinit4                 * OK, Baugruppe voll bestueckt
 move #1535, d0                 * Ergebnis 'Kapazitaet 1536 kB'
 bra.s srdinite
srdinit4:
 move #2047, d0                 * Ergebnis 'Kapazitaet 2048 kB'
srdinite:
 move.b #1, flo2srd(a5)         * Umleitung fr Floppy4 auf SRD
srdinitx:
 move d0, srdcap(a5)
 movem.l (a7)+, d0/a0/a1
 rts

sridtst:
 move.b d0, srdsecl.w           * Setze Sektornummer Low Byte
 lsr #8, d0
 move.b d0, srdsech.w           * Setze Sektornummer High Byte
 lea idebuff(a5), a0            * IDEBUFFER als Hilfspeicher
 move.b (a1), (a0)+             * Sichere aktuelle Inhalt
 move.b (a1), (a0)+
 move.b (a1), (a0)+
 move.b (a1), (a0)+
 move.b d0, srdsech.w           * Setze Bytezaehler zurck
 lea srdkenn(pc), a0
 move.b (a0)+, (a1)             * Schreibe Kennung in Sektor
 move.b (a0)+, (a1)
 move.b (a0)+, (a1)
 move.b (a0)+, (a1)
 move.b d0, srdsech.w           * Setze Bytezaehler zurck
 lea idebuff+4(a5), a0
 move.b (a1), (a0)+             * Lese Kennung wieder in Puffer
 move.b (a1), (a0)+
 move.b (a1), (a0)+
 move.b (a1), (a0)+
 move.b d0, srdsech.w           * Setze Bytezaehler zurck
 lea idebuff(a5), a0
 move.b (a0)+, (a1)             * Stelle Inhalt des Sektor wieder her
 move.b (a0)+, (a1)
 move.b (a0)+, (a1)
 move.b (a0)+, (a1)
 move.l idebuff+4(a5), d0       * Vergleiche Kennung nach Schreiben
 cmp.l srdkenn(pc), d0           * und Lesen aus Sektor
 beq.s sridtst1                 * -> Sektor vorhanden
 bra carset                     * Sektor nicht vorhanden, C = 1

sridtst1:
 bra carres                     * Sektor vorhanden, C = 0


srdkenn:
 dc.l $55AA33CC                 * Kennung fuer Pruefung


srdisk:                         * Schreib- und Lesezugriffe
                                * auf SRAMDISK
 movem.l d1-d2/a0, -(a7)
 subq #1, d1                    * Befehl -1
 bmi.s srderr                   * nur Befehl Sektor lesen 1(0)
 cmp #1, d1                     * und Sektor schreiben 2(1) zulssig
 bgt.s srderr
 subq.l #1, d2                  * Sektor auf 0-n
 bmi.s srderr                   * Es gibt keinen Sektor 0
 clr.l d0
 move d3, d0                    * Spur nach d0
 lsl.l #3, d0                   * Spur *8
srd01:
 add.l d2, d0
 cmp srdcap(a5), d0             * Sektor gltig?
 bhi.s srderr                   * Nein, Fehler!
 tst d1                         * Sektor lesen?
 bne.s srd02                    * nein, dann schreiben
 bsr srdread
 bra.s srdex
srd02:
 bsr srdwrite
 bra.b srdex
srderr:
 move #-1, d0
 movem.l (a7)+, d1-d2/a0
 bra carset
srdex:
 clr d0
 movem.l (a7)+, d1-d2/a0
 bra carres
 rts


srdread:                        * Sektor von SRAMDISK lesen
                                * d0 = Sektornummer
                                * a0 = Zieladresse
 movem.l a1, -(a7)
 lea srddata.w, a1              * Lade Datenregisteradresse
 move.b d0, srdsecl.w           * Setze Sektornummer Low Byte
 lsr #8, d0
 move.b d0, srdsech.w           * Setze Sektornummer High Byte
 move #255, d0                  * Anzahl Bloecke fuer Zaehler
srdrdlp:
 move.b (a1), (a0)+             * bertrage ein Byte in den Puffer
 move.b (a1), (a0)+
 move.b (a1), (a0)+
 move.b (a1), (a0)+
 dbra d0, srdrdlp               * Lese gesamten Sektor
 movem.l (a7)+, a1
rts


srdwrite:                       * Sektor auf SRAMDISK schreiben
                                * d0 = Sektor
                                * a0 = Quelladresse
 movem.l a1, -(a7)
 lea srddata.w, a1              * Lade Datenregisteradresse
 move.b d0, srdsecl.w           * Setze Sektornummer Low Byte
 lsr #8, d0
 move.b d0, srdsech.w           * Setze Sektornummer High Byte
 move #255, d0                  * Anzahl Bloecke fuer Zaehler
srdwrlp:
 move.b (a0)+, (a1)             * bertrage ein Byte zur SRAMDISK
 move.b (a0)+, (a1)
 move.b (a0)+, (a1)
 move.b (a0)+, (a1)             * Block geschrieben
 dbra d0, srdwrlp               * Schreibe gesamten Sektor
 movem.l (a7)+, a1
rts

setf2s:                         * Floppy4 nach SRAMDISK Umleitung setzen
 move.b d0, flo2srd(a5)
 rts

getf2s:                         * Floppy4 nach SRAMDISK Umleitung laden
 move.b flo2srd(a5), d0
 rts

getsrd:                         * Grsse der SRAMDISK abfragen
 move srdcap(a5), d0
 rts
  f                            * Floppy4 nach SRAMDISK Umleitung laden
 move.b flo2srd(a5), d0
 rts

getsrd:                         * Grsse der SRAMDISK abfragen
 move srdcap(a5), d0
 rts
                                                                                                                                                                                                                                                                                                                                                                                                 * Wenn '', dann ' bernehmen
 bne.s fakto14                  * Wenn ' dann Ende
fakto13:
 cmp.b #' ',(a0)                * Wenn Ctrl-Zeichen, dann Abbruch
 bcs.s fakto15
 rol.l #8,d0                    * Sonst Zeichen bernehmen
 move.b (a0)+,d0                * Nach d0
bra.s fakto12                   * Nchstes Zeichen testen

fakto14:
 addq.l #1,a0
fakto15:                        * Fehlerbehandlung
 cmp #5,d1                      * Bei undefinert, so lassen
 beq carres
 moveq #3,d1         